import React from 'react';

interface FloralThemeProps {
  mode: 'light' | 'dusky';
}

const FloralTheme: React.FC<FloralThemeProps> = ({ mode }) => {
  const styles = {
    light: {
      backgroundColor: '#ffffff',
      color: '#333333',
      accentColor: '#ff69b4',
      secondaryColor: '#f8e8ee',
      borderColor: '#e0e0e0',
      backgroundImage: 'url("/public/images/royalty-free/floral border.jpg")',
    },
    dusky: {
      backgroundColor: '#2c2c2c',
      color: '#ffffff',
      accentColor: '#ff1493',
      secondaryColor: '#4a2f3b',
      borderColor: '#404040',
      backgroundImage: 'url("/public/images/royalty-free/roses jewel pink.png")',
    },
  };

  return (
    <div style={styles[mode]}>
      {/* Rest of the component content */}
    </div>
  );
};

export default FloralTheme; 